<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="col-md-9 row">
            <header class="panel-heading">
                <?php echo lang('add');?> <?php echo lang('surgery');?>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">
                    <div class="clearfix">
                        <?php echo validation_errors(); ?>
                        <form role="form" action="surgery/addSurgery" class="clearfix row" method="post" enctype="multipart/form-data">
                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('patient'); ?>*</label>
                                <select class="form-control m-bot15" id="patientchoose" name="patient" required> 
                                </select>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('patient'); ?> <?php echo lang('guardian'); ?>*</label>
                                <input type="text" class="form-control" name="guardian" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('indication'); ?>*</label>
                                <input type="text" class="form-control" name="indication" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('incision'); ?>*</label>
                                <input type="text" class="form-control" name="incision" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('findings'); ?>*</label>
                                <input type="text" class="form-control" name="findings" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('operation'); ?>*</label>
                                <select class="form-control js-example-basic-single" name="operation" required>
                                    <option></option>
                                    <?php foreach ($services as $service) { ?>
                                        <option value="<?php echo $service->id; ?>"><?php echo $service->category; ?></option>
                                    <?php } ?> 
                                </select>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('surgeon'); ?>*</label>
                                <select class="form-control m-bot15 doctorchoose" name="surgeon" required> 
                                </select>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('assistant'); ?>*</label>
                                <input type="text" class="form-control" name="assistant" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('anaestheasist'); ?>*</label>
                                <select class="form-control m-bot15 doctorchoose" name="anaestheasist" required> 
                                </select>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('anaestheasia'); ?>*</label>
                                <input type="text" class="form-control" name="anaes_f" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('others'); ?></label>
                                <input type="text" class="form-control" name="others">
                            </div>

                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                                <select class="form-control m-bot15" name="status" required> 
                                    <option><?php echo lang('in_progress');?></option>
                                    <option><?php echo lang('done');?></option>   
                                </select>
                            </div>

                            <input type="hidden" name="id" value='<?php
                            if (!empty($surgery->id)) {
                                echo $surgery->id;
                            }
                            ?>'>

                            
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right"><?php echo lang('submit'); ?></button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<script>
    $(document).ready(function () {
        $("#patientchoose").select2({
            minimumInputLength: 2,
            placeholder: '<?php echo lang('select_patient'); ?>',
            allowClear: true,
            ajax: {
                url: 'patient/getPatientinfo',
                type: "post",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        searchTerm: params.term // search term
                    };
                },
                processResults: function (response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }

        });
   
        $(".doctorchoose").select2({
            placeholder: '<?php echo lang('select_doctor'); ?>',
            allowClear: true,
            ajax: {
                url: 'doctor/getDoctorWithAddNewOptionforLab',
                type: "post",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        searchTerm: params.term // search term
                    };
                },
                processResults: function (response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }

        });

    });
</script>