<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Inventory_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertInventory($data) {
        $this->db->insert('inventory', $data);
    }

    function loadInventory($data) {
        $this->db->insert('inventory_load_list', $data);
    }

    function getInventory() {
        //$this->db->order_by('name', 'asc');
        $query = $this->db->get('inventory');
        return $query->result();
    }

    function getInventoryForms() {
        $this->db->select('form');
        $this->db->order_by('form', 'asc');
        $this->db->distinct();
        $query = $this->db->get('inventory');
        return $query->result();
    }

    function getInventoryWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $this->db->select('*');         
        $this->db->from('inventory');
        return $query->result();
    }

    function getLatestInventory() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('inventory');
        return $query->result();
    }

    function getInventoryLimitByNumber($number) {
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory', $number);
        return $query->result();
    }

    function getInventoryByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory', 50, $data_range_1);
        return $query->result();
    }

    function getInventoryByStockAlert() {
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory');
        return $query->result();
    }

    function getInventoryByStockAlertByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory', 50, $data_range_1);
        return $query->result();
    }

    function getInventoryById($id) {
        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('inventory');  
        $query = $this->db->get(); 
        return $query->row();
    }


    function getInventoryByIdforLoad($id) {
        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('inventory');  
        $query = $this->db->get(); 
        return $query->row();
    }

    function getInventoryByKeyByStockAlert($page_number, $key) {
        $data_range_1 = 50 * $page_number;

        $this->db->where('quantity <=', 20);
        $this->db->or_like('name', $key);
        $this->db->or_like('company', $key);



        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory', 50, $data_range_1);
        return $query->result();
    }

    function getInventoryByKey($page_number, $key) {
        $data_range_1 = 50 * $page_number;
        $this->db->like('name', $key);
        $this->db->or_like('company', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory', 50, $data_range_1);
        return $query->result();
    }

    function getInventoryByKeyForPos($key) {
        $this->db->like('name', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('inventory');
        return $query->result();
    }

    function updateInventory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('inventory', $data);
    }

    function insertInventoryCategory($data) {

        $this->db->insert('inventory_category', $data);
    }

    function getInventoryGeneric() {
        $this->db->order_by('generic_name', 'asc');
        $query = $this->db->get('inventory_generic');
        return $query->result();
    }

    function getInventoryCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('inventory_category');
        return $query->row();
    }
    
    function getInventoryCompany() {
        $this->db->order_by('company_name', 'asc');
        $query = $this->db->get('inventory_company');
        return $query->result();
    }

    function totalStockPrice() {
        $query = $this->db->get('inventory')->result();
        $stock_price = array();
        foreach ($query as $inventory) {
            $stock_price[] = $inventory->price * $inventory->quantity;
        }

        if (!empty($stock_price)) {
            return array_sum($stock_price);
        } else {
            return 0;
        }
    }

    function updateInventoryCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('inventory_category', $data);
    }

    function deleteInventory($id) {
        $this->db->where('id', $id);
        $this->db->delete('inventory');
    }

    function deleteLoadInventory($id) {
        $this->db->where('id', $id);
        $this->db->delete('inventory_load_list');
    }

    function deleteInventoryCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('inventory_category');
    }

    function getInventoryBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('*');
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('category', $search,'after');
        $this->db->or_like('company', $search,'after');   
        $this->db->or_like('storage', $search,'after');       
        $this->db->from('inventory'); 
        $query = $this->db->get();
        return $query->result();
        }
    }

    function getInventoryByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('*');
        $this->db->from('inventory'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
    }

    function getInventoryByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('*');
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('category', $search,'after');
        $this->db->or_like('company', $search,'after');   
        $this->db->or_like('storage', $search,'after');         
        $this->db->from('inventory'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
     }
    }

    function getInventoryNameByAvailablity($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('inventory');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
            $this->db->limit(10);
            $fetched_records = $this->db->get('inventory');
            $query = $fetched_records->result();
        }

        return $query;
    }


    function getInventoryExpireAlertBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('inventory_expire_period')));
        $this->db->where('status', lang('inventory_batch_status_available'));
        $this->db->group_start();
       // $this->db->like('id', $search);
        $this->db->like('name', $search);
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('company', $search,'after');
        $this->db->or_like('batch_no', $search,'after');
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->group_end();
        $query = $this->db->get('inventory');
        return $query->result();
        }
    }

    function getInventoryExpireAlertByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('inventory_expire_period')));
        $this->db->where('status', lang('inventory_batch_status_available'));
        $query = $this->db->get('inventory_load_list');
        return $query->result();
    }

    function getInventoryExpireAlertByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('inventory_expire_period')));
        $this->db->where('status', lang('inventory_batch_status_available'));
        $this->db->group_start();
        //$this->db->like('id', $search);
        $this->db->like('name', $search);
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('company', $search,'after');
        $this->db->or_like('batch_no', $search,'after');
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->group_end();
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_load_list');
        return $query->result();
        }
    }

    function getInventoryExpireAlert() {   
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('inventory_expire_period')));
        $this->db->where('status', lang('inventory_batch_status_available'));
        $query = $this->db->get('inventory_load_list');
        return $query->result();
    }

    function getInventoryExpireAlertWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('inventory_expire_period')));
        $this->db->where('status', lang('inventory_batch_status_available'));
        $query = $this->db->get('inventory_load_list');
        return $query->result();
    }


    function getGenericName($generic) {
        $this->db->where('generic_id', $generic);
        $query = $this->db->get('inventory_generic');
        return $query->result_array();
    }

    function getLoadInventoryWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $query = $this->db->get('inventory_load_list');
        return $query->result();
    }

    function getLoadInventoryBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('entry_type', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $query = $this->db->get('inventory_load_list');
        return $query->result();
        }
    }

    
    function getLoadInventoryByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_load_list');
        return $query->result();
    }

    
    function getLoadInventoryByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('entry_type', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_load_list');
        return $query->result();
        }
    }

    function getLoadInventoryById($id) {
        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('inventory_load_list');  
        $query = $this->db->get(); 
        return $query->row();
    }

    function getLoadInventoryByInventoryId($id) {
        $this->db->select('*');
        $this->db->where('inventory_id',$id);
        $this->db->from('inventory_load_list');  
        $query = $this->db->get(); 
        return $query->result();
    }

    function updateLoadInventory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('inventory_load_list', $data);
    }

    function getInventoryListGroupBy() {
        $this->db->select('inventory.id,inventory.price, inventory.s_price,inventory.name,inventory.strength,inventory.form,sum(inventory_load_list.quantity) AS quantity');
        $this->db->from('inventory'); 
        $this->db->join('inventory_load_list', 'inventory.id=inventory_load_list.inventory_id','LEFT'); 
        $this->db->group_by('inventory.id'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function insertUse($data) {
        $this->db->insert('inventory_use_list', $data);
    }

    function deleteUse($id) {
        $this->db->where('id', $id);
        $this->db->delete('inventory_use_list');
    }

    function getUseInventoryWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $query = $this->db->get('inventory_use_list');
        return $query->result();
    }

    function getUseInventoryBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('purpose', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $query = $this->db->get('inventory_use_list');
        return $query->result();
        }
    }

    
    function getUseInventoryByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_use_list');
        return $query->result();
    }

    
    function getUseInventoryByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('purpose', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_use_list');
        return $query->result();
        }
    }

    function getInventoryCompanies() {
        $this->db->select('company');
        $this->db->from('inventory'); 
        $this->db->group_by('company'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function getInventoryCategories() {
        $this->db->select('category');
        $this->db->from('inventory'); 
        $this->db->group_by('category'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function getInventoryPacksizes() {
        $this->db->select('packsize');
        $this->db->from('inventory'); 
        $this->db->group_by('packsize'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function getInventoryStorages() {
        $this->db->select('storage');
        $this->db->from('inventory'); 
        $this->db->group_by('storage'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function insertRequest($data) {
        $this->db->insert('inventory_request_list', $data);
    }

    function deleteRequest($id) {
        $this->db->where('id', $id);
        $this->db->delete('inventory_request_list');
    }

    function getRequestInventoryWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $query = $this->db->get('inventory_request_list');
        return $query->result();
    }

    function getRequestInventoryBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('remarks', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->or_like('status', $search,'after');
        $query = $this->db->get('inventory_request_list');
        return $query->result();
        }
    }

    function getRequestInventoryByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_request_list');
        return $query->result();
    }

    
    function getRequestInventoryByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('remarks', $search);
        $this->db->or_like('inventory_id', $search,'after');
        $this->db->or_like('status', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('inventory_request_list');
        return $query->result();
        }
    }

    function getRequestInventoryById($id) {
        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('inventory_request_list');  
        $query = $this->db->get(); 
        return $query->row();
    }

    function updateRequestInventory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('inventory_request_list', $data);
    }

    function getLoadInventoryByDate($date_from, $date_to) {
        $this->db->select('name, sum(quantity) AS tot_load,count(name) AS freq_load');
        $this->db->from('inventory_load_list');
        $this->db->where('add_date >=', $date_from);
        $this->db->where('add_date <=', $date_to);
        $this->db->group_by('inventory_id'); 
        $query = $this->db->get();
        return $query->result();
    }

    function getUseInventoryByDate($date_from, $date_to) {
        $this->db->select('name, sum(quantity) AS tot_used,count(name) AS freq_used');
        $this->db->from('inventory_use_list');
        $this->db->where('add_date >=', $date_from);
        $this->db->where('add_date <=', $date_to);
        $this->db->group_by('inventory_id'); 
        $query = $this->db->get();
        return $query->result();
    }

}
