<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Doctor_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertDoctor($data) {
        $this->db->insert('doctor', $data);
    }

    function getDoctor() {
        $query = $this->db->get('doctor');
        return $query->result();
    }

    function getDoctorWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get('doctor');
        return $query->result();
    }

    function getDoctorBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('email', $search,'after');
        $this->db->or_like('bmdc', $search);
        $this->db->or_like('department', $search,'after');
        $query = $this->db->get('doctor');
        return $query->result();
        }
    }

    function getDoctorByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('doctor');
        return $query->result();
    }

    function getDoctorByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {

        $this->db->like('id', $search,'after');

        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }

        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('email', $search, 'after');
        $this->db->or_like('bmdc', $search);
        $this->db->or_like('department', $search, 'after');
        $this->db->or_like('dr_category', $search, 'after');

        $this->db->limit($limit, $start);
        $query = $this->db->get('doctor');
        return $query->result();
        }
    }

    function getDoctorById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('doctor');
        return $query->row();
    }

    function getDoctorByIonUserId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('doctor');
        return $query->row();
    }

    function updateDoctor($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('doctor', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('doctor');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    //added by sharait
    function updateIonUserNew($username, $email, $password, $ion_user_id,$active) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password,
            'active' => $active
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getDoctorInfo($searchTerm) {
            $this->db->order_by('name', 'asc'); //added by shariat
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->select('*');
            $this->db->where('dr_category', lang('status_active'));	//added by shariat		
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '" . $searchTerm . "%' ");
			$this->db->or_where("department like '" . $searchTerm . "%' ");
			$this->db->or_where("address like '" . $searchTerm . "%' ");
			$this->db->or_where("profile like '%" . $searchTerm . "%' ");            
						
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
            }
        } else {
            $this->db->select('*');
            $this->db->where('dr_category', lang('status_active')); //added by shariat		
            //$this->db->limit(5); //changed by shariat
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }


        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $this->db->select('*');
            $this->db->where('ion_user_id', $doctor_ion_id);
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }


        // Initialize Array with fetched data
        $data = array();
        foreach ($users as $user) {
             $data[] = array("id" => $user['id'], "text" => $user['name'] . ', '. $user['department'] .', '. $user['address'] . ', '. $user['profile'] .', ' . lang('id') . ': ' . $user['id']);
        }
        return $data;
    }

    function getDoctorWithAddNewOption($searchTerm) {
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '" . $searchTerm . "%' ");
			$this->db->or_where("department like '" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
            }
        } else {
            $this->db->order_by('dr_category', 'ASC'); //added by shariat
            $this->db->order_by('id', 'ASC'); //added by shariat
            $this->db->select('*');
            $this->db->where('dr_category', lang('status_active')); 	
            $this->db->or_where('dr_category', lang('status_frequent')); 	
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }


        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $this->db->select('*');
            $this->db->where('ion_user_id', $doctor_ion_id);
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }



        // Initialize Array with fetched data
        $data = array();
        $data[] = array("id" => 'add_new', "text" => lang('add_new'));
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => $user['name'] . ', ' . lang('id') . ': ' . $user['id']);
        }
        return $data;
    }
	
	//added by shariat
	    function getDoctorWithAddNewOptionforLab($searchTerm) {
            $this->db->order_by('name', 'asc'); //added by shariat
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '" . $searchTerm . "%' ");
			$this->db->or_where("department like '" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
            }
        } else {
            $this->db->select('*');
            // $this->db->where("name like '%".$searchTerm."%' ");
            //  $this->db->or_where("id like '%".$searchTerm."%' ");
            //$this->db->limit(5);
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }


        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $this->db->select('*');
            $this->db->where('ion_user_id', $doctor_ion_id);
            $fetched_records = $this->db->get('doctor');
            $users = $fetched_records->result_array();
        }



        // Initialize Array with fetched data
        $data = array();
        //$data[] = array("id" => 'add_new', "text" => lang('add_new'));
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => $user['name'].', '. $user['department'] . ', '. $user['phone'] .', ' . lang('id') . ': ' . $user['id']);
        }
        return $data;
    }

}
