<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Inventory extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventory_model');
        $this->load->model('finance/finance_model');
        if (!$this->ion_auth->in_group(array('admin', 'Laboratorist','Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['companies'] = $this->inventory_model->getInventoryCompanies();
        $data['storages'] = $this->inventory_model->getInventoryStorages();
        $data['packsizes'] = $this->inventory_model->getInventoryPacksizes();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function home() {
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
        $data = array();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['latest_medicines'] = $this->medicine_model->getLatestMedicine();
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->inventory_model->getPayment();
        $data['expenses'] = $this->inventory_model->getExpense();
        $data['today_sales_amount'] = $this->inventory_model->todaySalesAmount();
        $data['today_expenses_amount'] = $this->inventory_model->todayExpensesAmount();


        $data['this_month']['payment'] = $this->inventory_model->thisMonthPayment();
        $data['this_month']['expense'] = $this->inventory_model->thisMonthExpense();


        $data['this_day']['payment'] = $this->inventory_model->thisDayPayment();
        $data['this_day']['expense'] = $this->inventory_model->thisDayExpense();

        $data['this_year']['payment'] = $this->inventory_model->thisYearPayment();
        $data['this_year']['expense'] = $this->inventory_model->thisYearExpense();


        $data['this_year']['payment_per_month'] = $this->inventory_model->getPaymentPerMonthThisYear();

        $data['this_year']['expense_per_month'] = $this->inventory_model->getExpensePerMonthThisYear();


        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory/home', $data);
        $this->load->view('home/footer');
    }

    public function inventoryByPageNumber() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['inventorys'] = $this->inventory_model->getInventoryByPageNumber($page_number);
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['pagee_number'] = $page_number;
        $data['p_n'] = $page_number;
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function inventoryStockAlert() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = '0';
        $data['inventorys'] = $this->inventory_model->getInventoryByStockAlert($page_number);
        //  $data['inventorys'] = $this->inventory_model->getInventoryByStockAlertByPageNumber($page_number);
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['pagee_number'] = $page_number;
        $data['settings'] = $this->settings_model->getSettings();
        $data['alert'] = 'Alert Stock';
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function inventoryStockAlertByPageNumber() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $data['inventorys'] = $this->inventory_model->getInventoryByStockAlert($page_number);
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['pagee_number'] = $page_number;
        $data['alert'] = 'Alert Stock';
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function searchInventory() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $key = $this->input->get('key');
        $data['inventorys'] = $this->inventory_model->getInventoryByKey($page_number, $key);
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $data['pagee_number'] = $page_number;
        $data['key'] = $key;
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function searchInventoryInAlertStock() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $key = $this->input->get('key');
        $data['inventorys'] = $this->inventory_model->getInventoryByKeyByStockAlert($page_number, $key);
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $data['pagee_number'] = $page_number;
        $data['key'] = $key;
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addInventoryView() {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->inventory_model->getInventoryCategories();
        $data['companies'] = $this->inventory_model->getInventoryCompanies();
        $data['storages'] = $this->inventory_model->getInventoryStorages();
        $data['packsizes'] = $this->inventory_model->getInventoryPacksizes();
        $data['service_categories'] = $this->finance_model->getPaymentCategoryByService();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_inventory_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewInventory() {
        $id = $this->input->post('id');           
        $category = $this->input->post('category');
        $company = $this->input->post('company');
        $packsize = $this->input->post('packsize');
        $storage = $this->input->post('storage');

        if (empty($id)) {
            $add_date =  time();
        } else {
            $updated_date = time();
        }

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating category Field
        $this->form_validation->set_rules('category', 'Category', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Company Name Field
        $this->form_validation->set_rules('company', 'Company', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Pack size Field
        $this->form_validation->set_rules('packsize', 'Pack Size', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating storage Name Field
        $this->form_validation->set_rules('storage', 'Storage', 'trim|min_length[1]|max_length[100]|xss_clean');
    

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $data['categories'] = $this->inventory_model->getInventoryCategories();
            $data['companies'] = $this->inventory_model->getInventoryCompanies();
            $data['storages'] = $this->inventory_model->getInventoryStorages();
            $data['packsizes'] = $this->inventory_model->getInventoryPacksizes();
            $data['service_categories'] = $this->finance_model->getPaymentCategoryByService();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_inventory_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $user=$this->ion_auth->get_user_id();
            $name = $this->finance_model->getPaymentServiceCategoryById($category)->category;
            $data = array();
            $data = array('name' => $name,
                'category' => $category,
                'company' => $company,
                'packsize' => $packsize,
                'storage' => ucfirst($storage),
                'add_date' => $add_date,
                'user' => $user,
            );

            $data1 = array();
            $data1 = array(
                'company' => $company,
                'packsize' => $packsize,
                'storage' => ucfirst($storage),
                'updated_date' => $updated_date,
                'user' => $user,
            );
            if (empty($id)) {
                $this->inventory_model->insertInventory($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->inventory_model->updateInventory($id, $data1);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('inventory');
        }
    }

    function editInventory() {
        $data = array();
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $id = $this->input->get('id');
        $data['inventory'] = $this->inventory_model->getInventoryById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_inventory_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function loadInventory() {
        $id = $this->input->post('id');
        $qty = $this->input->post('qty');
        $batch_no = $this->input->post('batch_no');
        $e_date = strtotime($this->input->post('e_date'));
        $remarks = $this->input->post('remarks');
        $supplier = $this->input->post('supplier');
        $p_price = $this->input->post('p_price');
  
        $inventory = $this->inventory_model->getInventoryByIdforLoad($id);
        $inventory_details=$inventory->name;
        $add_date=time();
        $user=$this->ion_auth->get_user_id();
        $data = array();
        $data = array(            
            'name' =>$inventory_details ,
            'inventory_id' => $id,
            'quantity' => $qty,           
            'batch_no' => $batch_no,
            'supplier' => $supplier,
            'p_price' => $p_price,
            'e_date' => $e_date,
            'remarks' => $remarks,
            'add_date' => $add_date,
            'status' => lang('inventory_batch_status_available'),
            'user' => $user,
        );
        $this->inventory_model->loadInventory($data);

        //update stock
        $previous_qty = $this->db->get_where('inventory', array('id' => $id))->row()->quantity;
        $new_qty = $previous_qty + $qty;
        $update_array=array();
        $update_array=array('quantity' => $new_qty);
        $this->inventory_model->updateInventory($id, $update_array);

        $this->session->set_flashdata('feedback', lang('inventory_loaded'));
        redirect('inventory/loadInventoryList');
    }

    function addUseInventory() {
        $id = $this->input->post('id');
        $qty = $this->input->post('qty');
        $purpose = $this->input->post('purpose');
        $entry_type =  $this->input->post('entry_type');
        $remarks = $this->input->post('remarks');
  
        $inventory = $this->inventory_model->getInventoryByIdforLoad($id);
        //print_r($inventory->name);
        $inventory_details=$inventory->name;
        $add_date=time();
        $user=$this->ion_auth->get_user_id();
        $data = array();
        $data = array(            
            'name' =>$inventory_details ,
            'inventory_id' => $id,
            'quantity' => $qty,           
            'purpose' => $purpose,
            'entry_type' => $entry_type,
            'remarks' => $remarks,
            'add_date' => $add_date,
            'user' => $user,
        );
        $this->inventory_model->insertUse($data);

        //update stock
        $previous_qty = $this->db->get_where('inventory', array('id' => $id))->row()->quantity;
        $new_qty = $previous_qty - $qty;
        $update_array=array();
        $update_array=array('quantity' => $new_qty);
        $this->inventory_model->updateInventory($id, $update_array);

        $this->session->set_flashdata('feedback', lang('inventory_used'));
        redirect('inventory/useInventoryList');
    }

    function editInventoryByJason() {
        $id = $this->input->get('id');
        $data['inventory'] = $this->inventory_model->getInventoryById($id);
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $this->inventory_model->deleteInventory($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('inventory');
    }

    public function inventoryCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['categories'] = $this->inventory_model->getInventoryCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addCategoryView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_category_view');
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_category_view');
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description
            );
            if (empty($id)) {
                $this->inventory_model->insertInventoryCategory($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->inventory_model->updateInventoryCategory($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('inventory/inventoryCategory');
        }
    }

    function edit_category() {
        $data = array();
        $id = $this->input->get('id');
        $data['inventory'] = $this->inventory_model->getInventoryCategoryById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_category_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editInventoryCategoryByJason() {
        $id = $this->input->get('id');
        $data['inventorycategory'] = $this->inventory_model->getInventoryCategoryById($id);
        echo json_encode($data);
    }

    function deleteInventoryCategory() {
        $id = $this->input->get('id');
        $this->inventory_model->deleteInventoryCategory($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('inventory/inventoryCategory');
    }

    function getInventoryList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "name",
            "2" => "category",
            "3" => "company",
            "4" => "quantity",
            "6" => "storage",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getInventoryByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getInventoryByLimit($limit, $start, $order, $dir);
            }

        $i = 0;
        foreach ($data['inventorys'] as $inventory) {           
            $settings = $this->settings_model->getSettings();
            if ($inventory->quantity <= 0) {
                $quan = $inventory->quantity.'  <em><span style="color:red">'.lang('stock_out_status').'<span></em>';
            } else {
                $quan = $inventory->quantity;
            }  
                   
            if ($this->ion_auth->in_group(array('admin','Accountant'))) {    
                $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/delete?id=' . $inventory->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
                $load = '<button type="button" class="btn btn-primary btn-xs btn_width load" data-toggle="modal" data-id="' . $inventory->id . '"><i class="fas fa-arrow-alt-circle-right"> ' . lang('load') . '</i></button>';
                $use = '<button type="button" class="btn btn-danger btn-xs btn_width use" data-toggle="modal" data-id="' . $inventory->id . '">' . lang('out') . ' <i class="fas fa-arrow-alt-circle-right"></i></button>';
            }

            if ($this->ion_auth->in_group(array('admin','Laboratorist','Accountant'))) {    
                $option1 = '<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $inventory->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</button>';
                $option3 = '<a target="_blank" class="btn btn-danger btn-xs btn_width" href="inventory/loadInventoryList?id=' . $inventory->id . '"><i class="fa fa-object-group"> </i> ' . lang('batches') . '</a>';
            }
            
            if ($this->ion_auth->in_group(array('Laboratorist'))) {    
               $request = '<button type="button" class="btn btn-primary btn-xs btn_width request" data-toggle="modal" data-id="' . $inventory->id . '">' . lang('request') . '</button>';
               }

            $info[] = array(
                $inventory->id,
                $inventory->name,
                $inventory->category,  
                $inventory->company,                             
                $quan . ' ' . $load . ' ' . $use,
                $inventory->packsize, 
                $inventory->storage, 
                $option3  . ' ' . $request. ' ' .$option1 . ' ' . $option2
            );
        }

        if (!empty($data['inventorys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('inventory'),
                "recordsFiltered" => $this->db->count_all_results('inventory'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getInventoryExpireAlertList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $today = time();
        $totalData=count($this->inventory_model->getInventoryExpireAlert());
       
        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "name",
            "2" => "e_date",
            "4" => "batch_no",
            "5" => "supplier",
            
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getInventoryExpireAlertByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getInventoryExpireAlertByLimit($limit, $start, $order, $dir);
            }
        
        foreach ($data['inventorys'] as $inventory) {           
               
            if ($this->ion_auth->in_group(array('admin','Laboratorist'))) {   
                $option1 = '<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $inventory->id . '"><i class="fa fa-edit"> </i> ' . lang('update_status') . '</button>'; 
             }

            if ($this->ion_auth->in_group(array('admin'))) {   
                $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/deleteLoadInventory?id=' . $inventory->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }
            
            $user =  $inventory->user;
            $userDetail = $this->db->get_where('users', array('id' => $user))->row();
            $warningPeriod=floor(($inventory->e_date - $today)/(lang('month_calculation')));  //in months

            if ($warningPeriod<lang('inventory_expire_period'))
            {
            if ($inventory->e_date < $today)
                $warning= '<br><em><span style="color:red">'.lang('expired').'</span></em>';
                else
                $warning= '<br><em><span style="color:red">'.$warningPeriod. lang('inventory_expire_unit').'</span></em>';
            }
            else 
            $warning='';

            $info[] = array(
                $inventory->id,
                $inventory->name.'; ID: '.$inventory->inventory_id,
                date('d-M-Y', $inventory->e_date). ' ' . $warning,
                $inventory->quantity,   
                $inventory->batch_no,    
                $inventory->supplier,                               
                $inventory->remarks,
                date('d-M-Y h:i A', $inventory->add_date),              
                $userDetail->username,
                $option1.' '.$option2
            );
        }

        if (!empty($data['inventorys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $totalData,
                "recordsFiltered" => $totalData,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getInventorynamelist() {
        $searchTerm = $this->input->post('searchTerm');

        $response = $this->inventory_model->getInventoryNameByAvailablity($searchTerm);
        $data = array();
        foreach ($response as $responses) {
            $data[] = array("id" => $responses->id, "data-id" => $responses->id, "data-med_name" => $responses->name, "text" => $responses->name);
        }

        echo json_encode($data);
    }


    public function inventoryExpireAlert() {
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_expire_list', $data);
        $this->load->view('home/footer'); // just the header file
    }


    public function loadInventoryList() {

        $inventoryId = $this->input->get('id');

        if (!empty($inventoryId))
        {
            $data['inventorys'] = $this->inventory_model->getLoadInventoryByInventoryId($inventoryId);
            $data['inventoryId'] = $inventoryId;
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('inventory_load_list_by_id', $data);
            $this->load->view('home/footer'); // just the header file
        }
        else{
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('inventory_load_list', $data);
            $this->load->view('home/footer'); // just the header file
        }
    }

    function getLoadInventoryList() {
        $settings = $this->settings_model->getSettings();
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $today = time();

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "name",
            "2" => "quantity",
            "5" => "supplier",
            "6" => "e_date",
            "7" => "status",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getLoadInventoryByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getLoadInventoryByLimit($limit, $start, $order, $dir);
        }
        
        foreach ($data['inventorys'] as $inventory) {           
               
            if ($this->ion_auth->in_group(array('admin','Accountant'))) {   
                $option1 = '<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $inventory->id . '"><i class="fa fa-edit"> </i> ' . lang('update_status') . '</button>'; 
             }

            if ($this->ion_auth->in_group(array('admin'))) {   
                $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/deleteLoadInventory?id=' . $inventory->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }
            
            $user =  $inventory->user;
            $userDetail = $this->db->get_where('users', array('id' => $user))->row();
            $warningPeriod=floor(($inventory->e_date - $today)/(lang('month_calculation')));  //in months
            if ($warningPeriod<lang('inventory_expire_period'))
            {
            if ($inventory->e_date < $today)
                $warning= '<br><em><span style="color:red">'.lang('expired').'</span></em>';
                else
                $warning= '<br><em><span style="color:red">'.$warningPeriod. lang('inventory_expire_unit').'</span></em>';
            }
            else 
            $warning='';

            if ($inventory->status==lang('inventory_batch_status_sold'))
            $status= '<span class="badge" style="border-radius:2px">'.$inventory->status. '</span>';
            else 
            $status= '<span class="badge" style="background-color:green;border-radius:2px">'.$inventory->status. '</span>';

            $info[] = array(
                $inventory->id,
                $inventory->name.'; ID: '.$inventory->inventory_id,
                $inventory->quantity, 
                $settings->currency. ' '.$inventory->p_price,   
                $inventory->batch_no,    
                $inventory->supplier,                
                date('d-M-Y', $inventory->e_date). ' ' . $warning,
                $status,
                $inventory->remarks,
                date('d-M-Y h:i A', $inventory->add_date),              
                $userDetail->username,
                $option1.' '.$option2
            );
        }

        if (!empty($data['inventorys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('inventory_load_list'),
                "recordsFiltered" => $this->db->count_all_results('inventory_load_list'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function deleteLoadInventory() {

        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
        $id = $this->input->get('id');  

         //update stock
         $query = $this->db->get_where('inventory_load_list', array('id' => $id))->row();
         $deleted_qty =  $query->quantity;
         $deleted_inventory_id =  $query->inventory_id;
         $previous_qty = $this->db->get_where('inventory', array('id' => $deleted_inventory_id))->row()->quantity;
         $new_qty = $previous_qty - $deleted_qty;
         $update_array=array();
         $update_array=array('quantity' => $new_qty);

         $this->inventory_model->updateInventory($deleted_inventory_id, $update_array);
         $this->inventory_model->deleteLoadInventory($id);

        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('inventory/loadInventoryList');
    }

    function editLoadInventoryByJason() {
        $id = $this->input->get('id');
        $data['inventory'] = $this->inventory_model->getLoadInventoryById($id);
        echo json_encode($data);
    }

    function updateLoadInventory() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $data = array();
        $data = array('status' => $status);

        $this->inventory_model->updateLoadInventory($id,$data);
        $this->session->set_flashdata('feedback', lang('updated'));
        redirect('inventory/loadInventoryList');
    }

    function updateInventoryExpireAlert() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $data = array();
        $data = array('status' => $status);

        $this->inventory_model->updateLoadInventory($id,$data);
        $this->session->set_flashdata('feedback', lang('updated'));
        redirect('inventory/inventoryExpireAlert');
    }

    function deleteUse() {
        $id = $this->input->get('id');  

         //update stock
         $query = $this->db->get_where('inventory_use_list', array('id' => $id))->row();
         $deleted_qty =  $query->quantity;
         $deleted_inventory_id =  $query->inventory_id;
         $previous_qty = $this->db->get_where('inventory', array('id' => $deleted_inventory_id))->row()->quantity;
         $new_qty = $previous_qty + $deleted_qty;
         $update_array=array();
         $update_array=array('quantity' => $new_qty);

         $this->inventory_model->updateInventory($deleted_inventory_id, $update_array);
         $this->inventory_model->deleteUse($id);

        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('inventory/useInventoryList');
    }

    public function useInventoryList() {
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('inventory_use_list', $data);
            $this->load->view('home/footer'); // just the header file
    }

    function getUseInventoryList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $today = time();

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "name",
            "2" => "quantity",
            "3" => "batch_no",
            "6" => "add_date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getUseInventoryBysearch($search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getUseInventoryWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getUseInventoryByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getUseInventoryByLimit($limit, $start, $order, $dir);
            }
        }
        foreach ($data['inventorys'] as $inventory) {           
            
            if ($this->ion_auth->in_group(array('admin'))) {   
                $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/deleteUse?id=' . $inventory->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }
            
            $user =  $inventory->user;
            $userDetail = $this->db->get_where('users', array('id' => $user))->row();

            $info[] = array(
                $inventory->id,
                $inventory->name.'; ID: '.$inventory->inventory_id,
                $inventory->quantity,   
                $inventory->purpose,
                $inventory->entry_type,                   
                $inventory->remarks,
                date('d-M-Y h:i A', $inventory->add_date),              
                $userDetail->username,
                $option1.' '.$option2
            );
        }

        if (!empty($data['inventorys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('inventory_use_list'),
                "recordsFiltered" => $this->db->count_all_results('inventory_use_list'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function addRequestInventory() {
        $id = $this->input->post('id');
        $qty = $this->input->post('qty');
        $remarks = $this->input->post('remarks');
  
        $inventory = $this->inventory_model->getInventoryByIdforLoad($id);
        //print_r($inventory->name);
        $inventory_details=$inventory->name;
        $add_date=time();
        $user=$this->ion_auth->get_user_id();


        $data = array();
        $data = array(            
            'name' =>$inventory_details ,
            'inventory_id' => $id,
            'quantity' => $qty,           
            'status' => lang('requested'),
            'remarks' => $remarks,
            'add_date' => $add_date,
            'user' => $user,
        );
        $this->inventory_model->insertRequest($data);

        $this->session->set_flashdata('feedback', lang('inventory_requested'));
        redirect('inventory/requestInventoryList');
    }

    public function requestInventoryList() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('inventory_request_list', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getRequestInventoryList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $today = time();

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "name",
            "2" => "quantity",
            "3" => "remarks",
            "4" => "status",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getRequestInventoryBysearch($search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getRequestInventoryWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['inventorys'] = $this->inventory_model->getRequestInventoryByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['inventorys'] = $this->inventory_model->getRequestInventoryByLimit($limit, $start, $order, $dir);
            }
        }
        foreach ($data['inventorys'] as $inventory) {           
            
            if ($this->ion_auth->in_group(array('admin'))) {   
                $option1 = '<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $inventory->id . '"><i class="fa fa-edit"> </i> ' . lang('update_status') . '</button>'; 
             }

            if ($this->ion_auth->in_group(array('admin'))) {   
                $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/deleteRequest?id=' . $inventory->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }
            
            $user =  $inventory->user;
            $userDetail = $this->db->get_where('users', array('id' => $user))->row();

            $info[] = array(
                $inventory->id,
                $inventory->name.'; ID: '.$inventory->inventory_id,
                $inventory->quantity,   
                $inventory->remarks,
                $inventory->status,                   
                date('d-M-Y h:i A', $inventory->add_date),              
                $userDetail->username,
                $option1.' '.$option2
            );
        }

        if (!empty($data['inventorys'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('inventory_request_list'),
                "recordsFiltered" => $this->db->count_all_results('inventory_request_list'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function deleteRequest() {
        $id = $this->input->get('id');  
        $this->inventory_model->deleteRequest($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('inventory/requestInventoryList');
    }

    function editRequestInventoryByJason() {
        $id = $this->input->get('id');
        $data['inventory'] = $this->inventory_model->getRequestInventoryById($id);
        echo json_encode($data);
    }

    function updateRequestInventory() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $remarks = $this->input->post('remarks');
        $data = array();
        $data = array('status' => $status,
                'remarks' => $remarks,
                'updated_date' => time()  );

        $this->inventory_model->updateRequestInventory($id,$data);
        $this->session->set_flashdata('feedback', lang('updated'));
        redirect('inventory/requestInventoryList');
    }

    function report() {
        $date_from = strtotime($this->input->post('date_from'));
        $date_to = strtotime($this->input->post('date_to'));
        if (!empty($date_to)) {
            $date_to = $date_to + 86399;
        }
        $data = array();
        //$data['payment_categories'] = $this->inventory_model->getPaymentCategory();
        //$data['expense_categories'] = $this->inventory_model->getExpenseCategory();        

        //by default today by shariat
        if(empty($date_from)&& empty($date_to)) {
        $data['day'] = 'Today';
        $hour = 0;
        $today = strtotime($hour . ':00:00'); // 0:00:00 means today
        $today_last = strtotime($hour . ':00:00') + 86399; //11:59:59 means today last time
        $data['loads'] = $this->inventory_model->getLoadInventoryByDate($today, $today_last);
        $data['uses'] = $this->inventory_model->getUseInventoryByDate($today, $today_last);    
        }
        else{
        $data['loads'] = $this->inventory_model->getLoadInventoryByDate($date_from, $date_to);
        $data['uses'] = $this->inventory_model->getUseInventoryByDate($date_from, $date_to);
        } 

        //print_r ( $data['loads']);
        //return;

        $data['from'] = $this->input->post('date_from');
        $data['to'] = $this->input->post('date_to');
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('inventory/report', $data);
        $this->load->view('home/footer'); // just the footer fi
    }
    

}

/* End of file inventory.php */
/* Location: ./application/modules/inventory/controllers/inventory.php */
