<!--sidebar end-->
<!--main content start-->
<script type="text/javascript" src="common/js/google-loader.js"></script>
<section id="main-content"> 

    <section class="wrapper site-min-height">           
        <style>         
            .panel-heading{
                margin-bottom: 20px;
            }             
            .state-overview .value h1 {
                font-weight: bold;
                font-size: 18px;
                margin-top: 5px;
            }

            p {
                font-weight: bold;
            }
        </style>


        <!--state overview start-->
        <div class="col-md-12">
            <header class="panel-heading">
                <i class="fa fa-home"></i>  <?php echo lang('pharmacy'); ?> <?php echo lang('dashboard'); ?>
            </header>
            <div class="row state-overview">
                <div class="col-lg-3 col-sm-6">
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <a href="finance/pharmacy/todaySales">
                        <?php } ?>
                        <section class="panel panel-moree">
                            <div class="symbol terques">
                                <i class="fa fa-plus"></i>
                            </div>
                            <div class="value">
                                <p> <?php echo lang('today_sales'); ?> </p>
                                <h1 class="">
                                    <?php echo $settings->currency; ?> <?php echo number_format($today_sales_amount, 0, '.', ','); ?>
                                </h1>
                            </div>
                        </section>
                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                        </a>
                    <?php } ?>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <a href="finance/pharmacy/todayExpense">
                        <?php } ?>
                        <section class="panel panel-moree">
                            <div class="symbol blue">
                                <i class="fa fa-minus"></i>
                            </div>
                            <div class="value">
                                <p> <?php echo lang('today_expense'); ?> </p>
                                <h1 class="">
                                    <?php echo $settings->currency; ?> <?php echo number_format($today_expenses_amount, 0, '.', ','); ?>
                                </h1>

                            </div>
                        </section>
                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                        </a>
                    <?php } ?>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <a href="medicine">
                        <?php } ?>
                        <section class="panel panel-moree">
                            <div class="symbol blue">
                                <i class="fa fa-medkit"></i>
                            </div>
                            <div class="value">
                                <p> <?php echo lang('current_stock'); ?> </p>
                                <h1 class="">
                                <?php
                                            $query_medicine = $this->db->get('medicine')->result();
                                            $i = 0;
                                            foreach ($query_medicine as $q_medicine) {
                                                if ($q_medicine->quantity > 0) {
                                                    $i = $i + $q_medicine->quantity;
                                                }
                                            }
                                            echo number_format($i, 0, '.', ',');
                                ?>
                                </h1>

                            </div>
                        </section>
                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                        </a>
                    <?php } ?>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <a href="medicine/medicineExpireAlert">
                        <?php } ?>
                        <section class="panel panel-moree">
                            <div class="symbol blue">
                                <i class="fa fa-user"></i>
                            </div>
                            <div class="value">
                                <p> <?php echo lang('expiring'); ?></p>
                                <h1 class="">
                                <?php 
                                    $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
                                    $this->db->where('status', lang('medicine_batch_status_available'));
                                    $query = $this->db->get('medicine_load_list');
                                    echo ($query->num_rows().' '. lang('batches'));
                                 ?>
                                </h1>
                            </div>
                        </section>
                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                        </a>
                    <?php } ?>
                </div>





                <?php if ($this->ion_auth->in_group(array('admin'))) { ?>

                    <div class="col-lg-7 col-sm-12">
                        <div id="chart_div" class="panel" style="height: 400px; margin-top: 0px;"></div>                      
                    </div>

                <?php } ?>




                <div class="col-md-5">
                    <!--work progress start-->
                    <section class="panel" style="padding-top: 10px;">
                        <div class="panel-body progress-panel">
                            <div class="task-progress">
                                <h1><?php echo lang('statistics'); ?></h1>
                                <p style="color:black"> <?php echo date('F, Y'); ?></p>
                            </div>
                        </div>
                        <table class="table table-hover personal-task">
                            <tbody>  
                                <tr>
                                    <td>1</td>
                                    <td>
                                        <?php echo lang('total_sales').' <em style="color:red">'. lang('with_due').'</em>'; ?>
                                    </td>
                                    <td>
                                        <span class="">
                                            <?php echo $settings->currency; ?>
                                            <?php
                                            $query = $this->db->get('pharmacy_payment')->result();
                                            $sales_total = array();
                                            foreach ($query as $q) {
                                                if (date('m', time()) == date('m', $q->date)) {
                                                    $sales_total[] = $q->gross_total;
                                                }
                                            }
                                            if (!empty($sales_total)) {
                                                echo number_format(array_sum($sales_total), 0, '.', ',');
                                            }
                                            ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div id="work-progress1"><canvas width="47" height="20" style="display: inline-block; width: 47px; height: 20px; vertical-align: top;"></canvas></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td>2</td>
                                    <td>
                                        <?php echo lang('total_expense'); ?>
                                    </td>
                                    <td>
                                        <span class="">
                                            <?php echo $settings->currency; ?>
                                            <?php
                                            $query_expense = $this->db->get('pharmacy_expense')->result();
                                            foreach ($query_expense as $q_expense) {
                                                if (date('m', time()) == date('m', $q_expense->date)) {
                                                    $expense_total[] = $q_expense->amount;
                                                }
                                            }
                                            if (!empty($expense_total)) {
                                                echo number_format(array_sum($expense_total), 0, '.', ',');
                                            }
                                            ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div id="work-progress2"><canvas width="47" height="22" style="display: inline-block; width: 47px; height: 22px; vertical-align: top;"></canvas></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td>3</td>
                                    <td>
                                        <strong><?php echo lang('total'); ?> <?php echo lang('profit'); ?></strong>
                                    </td>
                                    <td>
                                        <span class="">
                                            <?php echo $settings->currency; ?>
                                            <?php
                                            $revenue=0;
                                            $cost=0;
                                            if (!empty($sales_total)) {
                                            $revenue= array_sum($sales_total);
                                            }
                                            if (!empty($expense_total)) {
                                            $cost= array_sum($expense_total);
                                            }
                                            echo (number_format($revenue- $cost, 0, '.', ','));
                                            ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div id="work-progress2"><canvas width="47" height="22" style="display: inline-block; width: 47px; height: 22px; vertical-align: top;"></canvas></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td>3</td>
                                    <td>
                                        <span><?php echo lang('total'); ?> <?php echo lang('medicine'); ?></span> <?php echo lang('brand'); ?></span>
                                    </td>
                                    <td>
                                        <span class="">
                                            <?php
                                            $this->db->group_by('medicine_id');
                                            $query = $this->db->get('medicine_load_list');
                                            echo ($query->num_rows());
                                            ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div id="work-progress2"><canvas width="47" height="22" style="display: inline-block; width: 47px; height: 22px; vertical-align: top;"></canvas></div>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </section>
                    <!--work progress end-->

                </div>
            </div>


        </div>
        <!--state overview end-->
    </section>
</section>
<!--main content end-->



<script type="text/javascript">
    google.charts.load('current', {'packages': ['corechart']});
    google.charts.setOnLoadCallback(drawVisualization);

    function drawVisualization() {
        // Some raw data (not necessarily accurate)
        var data = google.visualization.arrayToDataTable([
            ['Month', '<?php echo lang('sales'); ?>', 'Expense', 'Profit'],
            ['Jan', <?php echo $this_year['payment_per_month']['january']; ?>, <?php echo $this_year['expense_per_month']['january']; ?>, <?php echo ($this_year['payment_per_month']['january']-$this_year['expense_per_month']['january']); ?>],
            ['Feb', <?php echo $this_year['payment_per_month']['february']; ?>, <?php echo $this_year['expense_per_month']['february']; ?> ,<?php echo ($this_year['payment_per_month']['february']-$this_year['expense_per_month']['february']); ?>],
            ['Mar', <?php echo $this_year['payment_per_month']['march']; ?>, <?php echo $this_year['expense_per_month']['march']; ?> ,<?php echo ($this_year['payment_per_month']['march']-$this_year['expense_per_month']['march']); ?>],
            ['Apr', <?php echo $this_year['payment_per_month']['april']; ?>, <?php echo $this_year['expense_per_month']['april']; ?> ,<?php echo ($this_year['payment_per_month']['april']-$this_year['expense_per_month']['april']); ?>],
            ['May', <?php echo $this_year['payment_per_month']['may']; ?>, <?php echo $this_year['expense_per_month']['may']; ?> ,<?php echo ($this_year['payment_per_month']['may']-$this_year['expense_per_month']['may']); ?>],
            ['June', <?php echo $this_year['payment_per_month']['june']; ?>, <?php echo $this_year['expense_per_month']['june']; ?> ,<?php echo ($this_year['payment_per_month']['june']-$this_year['expense_per_month']['june']); ?>],
            ['July', <?php echo $this_year['payment_per_month']['july']; ?>, <?php echo $this_year['expense_per_month']['july']; ?> ,<?php echo ($this_year['payment_per_month']['july']-$this_year['expense_per_month']['july']); ?>],
            ['Aug', <?php echo $this_year['payment_per_month']['august']; ?>, <?php echo $this_year['expense_per_month']['august']; ?>,<?php echo ($this_year['payment_per_month']['august']-$this_year['expense_per_month']['august']); ?>],
            ['Sep', <?php echo $this_year['payment_per_month']['september']; ?>, <?php echo $this_year['expense_per_month']['september']; ?>,<?php echo ($this_year['payment_per_month']['september']-$this_year['expense_per_month']['september']); ?>],
            ['Oct', <?php echo $this_year['payment_per_month']['october']; ?>, <?php echo $this_year['expense_per_month']['october']; ?>,<?php echo ($this_year['payment_per_month']['october']-$this_year['expense_per_month']['october']); ?>],
            ['Nov', <?php echo $this_year['payment_per_month']['november']; ?>, <?php echo $this_year['expense_per_month']['november']; ?>,<?php echo ($this_year['payment_per_month']['november']-$this_year['expense_per_month']['november']); ?>],
            ['Dec', <?php echo $this_year['payment_per_month']['december']; ?>, <?php echo $this_year['expense_per_month']['december']; ?>,<?php echo ($this_year['payment_per_month']['december']-$this_year['expense_per_month']['december']); ?>],
        ]);

        var options = {
            title: new Date().getFullYear() + ' <?php echo lang('per_month_income_expense'); ?>',
            vAxis: {title: '<?php echo $settings->currency; ?>'},
            hAxis: {title: '<?php echo lang('month'); ?>'},
            seriesType: 'bars',
            series: {5: {type: 'line'}}
        };

        var chart = new google.visualization.ComboChart(document.getElementById('chart_div'));
        chart.draw(data, options);
    }
</script>