<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
            <?php echo lang('surgery'); ?> <?php echo lang('list'); ?>
                <div class="col-md-4 no-print pull-right"> 
                    <a data-toggle="modal" href="surgery/addSurgeryView">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs">
                                <i class="fa fa-plus-circle"></i> <?php echo lang('add_new'); ?> <?php echo lang('surgery'); ?>
                            </button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('serial'); ?></th>
                                <th><?php echo lang('operation'); ?></th>
                                <th><?php echo lang('patient'); ?></th>
                                <th><?php echo lang('patient'); ?> <?php echo lang('guardian'); ?></th>                             
                                <th><?php echo lang('surgeon'); ?></th>
                                <th><?php echo lang('anaestheasist'); ?></th>
                                <th><?php echo lang('status'); ?></th>
                                <th><?php echo lang('added'); ?> <?php echo lang('date'); ?></th>
                                <th><?php echo lang('added_by'); ?></th>
                                <th class="no-print"><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>   

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"> <?php echo lang('edit'); ?>  <?php echo lang('surgery'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editSurgeryForm" class="clearfix row" action="surgery/editSurgery" method="post" enctype="multipart/form-data">
                
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1"><?php echo lang('serial'); ?></label>
                        <input type="text" class="form-control" name="id" required readonly>
                    </div>   
                
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1"><?php echo lang('operation'); ?></label>
                        <input type="text" class="form-control" name="operation" readonly>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1"><?php echo lang('patient'); ?></label>
                        <input type="text" class="form-control" name="patient" readonly>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1"><?php echo lang('surgeon'); ?></label>
                        <input type="text" class="form-control" name="surgeon" readonly>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                        <select class="form-control m-bot15" name="status" required> 
                            <option><?php echo lang('in_progress');?></option>
                            <option><?php echo lang('done');?></option>   
                        </select>
                    </div>

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right"><?php echo lang('submit'); ?></button>
                    </div>

                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,
            "processing": true,
            "serverSide": true,
            "searchable": true,
            "ajax": {
                url: "surgery/getSurgeryList",
                type: 'POST',
            },
            scroller: {
                loadingIndicator: true
            },
            dom: "<'row'<'col-md-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4,5,6,7,8,9],
                    }
                },
            ],
            aLengthMenu: [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            iDisplayLength: 50,
            "order": [[0, "desc"]],
            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
            }
        });
        table.buttons().container().appendTo('.custom_buttons');
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(8000).fadeOut(100);
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".editbutton", function () {
            // e.preventDefault(e);
            // Get the record's ID via attribute  
            var iid = $(this).attr('data-id');
            $('#editSurgeryForm').trigger("reset");
            $('#myModal2').modal('show');
            $.ajax({
                url: 'surgery/editSurgeryByJason?id=' + iid,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $('#editSurgeryForm').find('[name="id"]').val(response.surgery.id).end()
                $('#editSurgeryForm').find('[name="operation"]').val(response.operation).end()
                $('#editSurgeryForm').find('[name="patient"]').val(response.surgery.patient_name + ', '+ response.surgery.patient_phone+ ', ID: '+ response.surgery.patient).end()
                $('#editSurgeryForm').find('[name="status"]').val(response.surgery.status).end() 
                $('#editSurgeryForm').find('[name="surgeon"]').val(response.surgeon).end()                
            });
        });
    });
</script>
