<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
            <?php echo ucfirst(lang('status_running')); ?> <?php echo lang('alloted_beds'); ?>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                            <th><?php echo lang('id'); ?></th>
                                <th><?php echo lang('bed_name'); ?></th>
                                <th><?php echo lang('patient'); ?></th>
                                <th><?php echo lang('patient'); ?> <?php echo lang('guardian'); ?></th>
                                <th><?php echo lang('alloted_time'); ?></th>
                                <th><?php echo lang('diagnosis'); ?></th>
                                <th><?php echo lang('result'); ?></th>
                                <th><?php echo lang('doctor_admission'); ?></th>
                                <th class="no-print"><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($alloted_beds as $bed) { ?>
                                <tr class="">
                                    <td><?php echo $bed->id ?></td>
                                    <td><?php echo $bed->bed_name; ?></td>
                                    <td><?php echo $bed->patient_name.', '.$bed->patient_phone.', ID: '.$bed->patient; ?></td>
                                    <td><?php echo $this->patient_model->getPatientById($bed->patient)->guardian;?></td>
                                    <td><?php echo date ('d-m-Y h:i A',$bed->a_time); ?></td>
                                    <td><?php echo $bed->diagnosis; ?></td>
                                    <td><?php echo $bed->result; ?></td>
                                    <td><?php echo $bed->doctorName.', '.$bed->doctordepartment.', '.lang('id').': '. $bed->doctorId;?></td>
                                    <td class="no-print">
                                    <?php echo '<a target="_blank" class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="bed/printAllotment?id=' . $bed->id . '"><i class="fa fa-file-invoice"></i> ' . lang('print').' '. lang('admission') . '</a>'; ?>   
                                    <?php echo '<a class="btn btn-warning btn-xs btn_width" href="bed/cancelAllotmentView?id=' . $bed->id . '" ><i class="fa fa-window-close"> </i> ' . lang('cancel') . '</a>';?>    
         
                                    <?php if ($this->ion_auth->in_group('admin')) { ?> 
                                    <?php echo '<a class="btn btn-danger btn-xs btn_width" href="bed/deleteBedAllotment?id=' . $bed->id . '&bed_id=' .$bed->bed_id . '" onclick="return confirm(\'Are you sure you want to delete this allotment?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>'; ?>       
                                    <?php } ?>
                                </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,
            dom: "<'row'<'col-md-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4,5,6,7],
                    }
                },
            ],
            aLengthMenu: [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"]
            ],
            iDisplayLength: 50,
            "order": [[0, "desc"]],
            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
            }
        });
        table.buttons().container().appendTo('.custom_buttons');
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(8000).fadeOut(100);
    });
</script>
